# Vendor tiering model (simple and repeatable)

Use a tiering model so you don’t treat every vendor like a critical subprocessor. Tiering prevents over-collection and focuses reviewer time where it matters.

## Tier dimensions
Use two dimensions:
1) **Data exposure** (what data the vendor can access/store/process)
2) **Business criticality** (how much the business depends on the vendor)

## Example tiers

### Tier 1: Critical / high exposure
Typical characteristics:
- Direct access to production data or customer content
- Admin-level access or broad permissions
- Vendor outage would materially impact core operations

Suggested review depth:
- Full questionnaire and evidence index
- Third-party reports under agreement (if available)
- Incident response process and notification terms
- Annual re-review (or at renewal at minimum)

### Tier 2: Moderate exposure or criticality
Typical characteristics:
- Indirect access to customer metadata or limited integrations
- Operationally important but replaceable

Suggested review depth:
- Standard questionnaire subset and evidence index
- Ensure identity, logging, IR, and vendor management basics
- Re-review at renewal (or annually if exposure increases)

### Tier 3: Low exposure / non-critical
Typical characteristics:
- No customer data and no production access
- Low business impact if replaced

Suggested review depth:
- Lightweight questionnaire (baseline controls)
- Re-review at renewal or on material change

## Review triggers (regardless of tier)
Re-review when:
- The vendor has a security incident
- Your scope expands (new data category, new access type)
- The vendor introduces new subprocessors that touch in-scope data
- The contract renews
