# Vendor incident questionnaire (what to ask)

Use this when a vendor reports a potential incident, or when you suspect the vendor may be involved. The goal is to get a clear impact statement and a defensible decision trail.

## 1) Timeline and detection
- When was the incident first detected?
- What is the suspected start time and end time?
- How was it detected (alert type, report source)?
- When was containment achieved (if achieved)?

## 2) Scope
- What systems were affected?
- What data categories were involved (if any)?
- Was customer data accessed, exfiltrated, altered, or deleted?
- How did you determine impact (logs, forensics, other evidence)?

## 3) Your customer/tenant impact
- Are we impacted? If uncertain, what are the next steps to confirm?
- What identifiers can you provide for our validation (IOCs, affected accounts, IPs, timestamps)?
- What is the vendor’s confidence level (high/medium/low) and why?

## 4) Actions taken
- Containment actions taken (and when):
- Eradication steps:
- Recovery steps:
- Security control changes (password resets, key rotations, access reviews):

## 5) Communications
- What is your next update time and update cadence?
- Who is the incident point of contact?
- What communications have been sent to other customers (if any)?

## 6) Evidence and artifacts (as appropriate)
- Incident report or summary (sanitized if needed)
- Forensic report summary (if available)
- Logs relevant to our tenant/account (sanitized)
- Confirmation of remediation actions completed

## Notes
- This questionnaire is informational and is not legal advice.
- Keep requests proportional to impact and contractual obligations.
