# Vendor Review Workflow (Assign, Collect, Score, Decide, Export)

This workflow is designed to be repeatable and auditable.

## 1) Assign
- Define scope: what service is being evaluated and what data it will touch.
- Define access type: read-only, write, admin, production access, etc.
- Set a deadline and a reviewer (and backup reviewer).
- Decide tier (criticality and data exposure) so you don’t over-collect.

Outputs you should have after this step:
- A one-paragraph scope statement (what is in scope and why)
- Vendor tier (and the minimum evidence set you will request)
- Owner, deadline, and escalation path (who can approve exceptions)

## 2) Collect
- Send the questionnaire (`vendor-risk-assessment-template.csv`) and request evidence up front.
- Track artifacts with capture and expiration dates (`evidence-index-template.csv`).
- Avoid over-collecting: request only what maps to your inherent risk.

Evidence collection tips (reduce churn):
- Ask for a vendor’s **evidence index** first (artifact list and capture dates). It is faster than asking for random PDFs.
- Prefer exports/logs and short summaries over long narrative answers.
- If an artifact is agreement-required (SOC 2, pen test), request it under agreement and time-box access.
- Record “not available” explicitly so missing artifacts do not get silently ignored.

## 3) Score
- Use `risk-rating-rubric.md` for consistent Low/Medium/High scoring.
- Record rationale (auditors care about the decision trail, not just the artifacts).

Scoring guidance (practical):
- Score inherent risk based on your usage (data exposure, access, criticality), not the vendor’s marketing.
- Score control strength based on evidence (capture dates, scope notes, and what the artifact actually proves).
- If evidence is stale or scope is unclear, treat it as a risk signal.

## 4) Decide
- Approve / approve with conditions / reject.
- For “approve with conditions”, time-box follow-ups with owners and dates.
- Record exceptions and compensating controls.

Decision patterns that hold up in audits:
- Approve when scope is clear, evidence is current, and controls match inherent risk.
- Approve with conditions when core controls exist but sensitive reports or follow-ups are pending.
- Reject or escalate when the vendor’s controls cannot support your usage (or evidence is consistently unavailable).

## 5) Export (produce a due diligence evidence set)
- Use `due-diligence-export-structure.md` as the standard structure.
- Preserve:
  - The completed questionnaire
  - Evidence index
  - Evidence artifacts
  - Decision record (who, what, when, why)
  - Next review date and triggers

Tip: treat the exported evidence set as immutable. If you refresh artifacts later, append new evidence IDs rather than rewriting history.

## Review cadence (recommended)
- Re-review at renewal, after incidents, and after material changes.
- At minimum: annual re-review for high-risk vendors, and at renewal for others.
