# Vendor due diligence export structure

When auditors or customers ask “How do you review vendors?”, a clean export structure beats a folder of random PDFs.

## Recommended structure
1) **Vendor profile** (one page)
   - Service provided, data accessed, criticality, renewal date
2) **Security questionnaire** (completed)
3) **Evidence index** (table)
   - Artifact ID, captured date, expires, owner, link
4) **Third-party reports**
   - SOC 2 report or penetration test summary (if available)
5) **Privacy and data handling**
   - Retention and deletion policy, subprocessor list
6) **Decision record**
   - Risk rating, exceptions, compensating controls, approval
7) **Review cadence**
   - Next review date and triggers (material change, incident, renewal)

## Suggested folder layout (practical)
If you store vendor exports in a shared drive or Trust Center, a consistent folder layout prevents future confusion.

Example:
- `00_vendor_profile/`
- `01_questionnaire/`
- `02_evidence_index/`
- `03_reports/`
- `04_privacy/`
- `05_decision/`
- `06_followups/` (conditions, emails, closure proof)

## Practical guidance
- Do not over-collect. Request only what maps to your risk and data exposure.
- Preserve decisions. Auditors care about rationale and ownership, not only artifacts.
- Keep it current. Stale evidence is a common audit finding.

## Sharing guidance (optional)
- For sensitive reports, gate access behind an agreement and a time window.
- Prefer sharing one link and responding with updates, not sending attachments repeatedly.
