# SOC 2 scoping worksheet

Use this worksheet to define what “in scope” means *before* you gather evidence. A tight scope reduces rework, prevents contradictory answers, and makes sampling easier.

Tip: If you can’t answer “what systems are in scope” in one paragraph, evidence collection will sprawl.

## 1) Services in scope
- Product/service name(s):
- Customer-facing environments in scope (production, staging, etc.):
- Anything explicitly out of scope (legacy products, internal tooling):
- Shared responsibility notes (what customers configure vs what you operate):

## 2) Boundaries and dependencies (system description basics)
- Primary cloud provider(s) / hosting model:
- Major components (app, DB, message queue, storage, CDN, IdP):
- Third-party service providers in scope (ticketing, monitoring, CI/CD):
- Boundary diagram reference (link or filename):

## 3) Systems in scope (inventory)
List systems that generate evidence, including “systems of record”:
- Identity provider (IdP):
- Source control and CI/CD:
- Ticketing/ITSM:
- Monitoring/alerting:
- Logging platform:
- Endpoint management (MDM/EDR):
- HR/Onboarding:
- Training platform:
- Cloud accounts/projects:

## 4) Systems out of scope (and why)
- System:
- Why out of scope:
- Any compensating controls or assumptions:

## 5) Data flow summary (keep it simple and defensible)
- Where customer data enters:
- Where customer data is stored:
- Where customer data is processed:
- Where customer data leaves (exports, webhooks, integrations):
- Data categories handled (keep precise; avoid “we might”):

## 6) People and access
- Workforce in scope (employees, contractors, support):
- Privileged roles (admin, on-call, break-glass) and how defined:
- Support access model:
  - What support can access:
  - Approval requirements:
  - Time-boxing method:
  - Logging and review:

## 7) Audit period and sampling windows
- Report/audit period:
- Sampling expectations (ask your auditor early):
  - How many samples per control?
  - Which months/quarters are sampled?
  - Required system time zone format (UTC recommended):

## 8) Trust service criteria (TSC) in scope
Security is always included. Others are optional depending on your report and customer expectations.
- Availability:
- Confidentiality:
- Processing integrity:
- Privacy:

## 9) Evidence standards (define the quality bar)
- Preferred evidence format: exports/logs/reports > screenshots > narrative-only
- Minimum metadata per artifact:
  - Artifact ID:
  - Captured date:
  - Owner:
  - Cadence/refresh:
  - Scope notes:
  - Sensitivity and gating:
- Source of truth storage (where evidence lives and how it is organized):

## 10) Known exceptions and remediation
Auditors and buyers accept gaps when they are explicit and owned.

- Exception:
  - What is not implemented or not available:
  - Scope impact:
  - Compensating controls:
  - Owner:
  - Target date:
  - Proof you will provide when complete:
