# SOC 2 evidence checklist (practical)

This guide is a pragmatic starting point for common SOC 2 evidence categories. Tailor it to your scope and auditor expectations.

The goal is not “perfect compliance language”. The goal is **reviewer-ready evidence**: scoped, timestamped, owned, and easy to verify.

## The reviewer-ready standard
For each evidence item, capture:
- Artifact ID (so questions can cite it)
- Captured date and refresh cadence
- Owner (who can refresh it)
- Scope notes (what system/environment it covers)
- Sensitivity and gating requirements (public vs gated vs agreement-required)

Prefer exports/logs/reports over screenshots when possible.

## Evidence strategy: capture vs continuous
You will almost always need both:

### Evidence capture (scheduled exports)
Best for “snapshot” evidence:
- policies and approvals
- access reviews
- vendor inventory and subprocessors
- training completion

### Continuous checks (time-series)
Best for settings auditors ask about repeatedly:
- MFA enforcement status
- unexpected privileged role changes
- logging retention configuration
- backup success/failure trends

Practical approach: run scheduled checks (weekly/monthly), store outputs with timestamps, and link them in your evidence inventory.

## How to run this checklist (the workflow)
1) Confirm scope using `soc2-scoping-worksheet.md`.
2) Populate `soc2-evidence-checklist.csv` with the evidence artifacts you will maintain.
3) Assign owners and cadence per artifact.
4) Capture your first “baseline export set” (top 10 artifacts) and lock in the naming convention.
5) Track auditor requests in `soc2-pbc-tracker-template.csv` so requests map cleanly to evidence IDs.

## Common evidence categories (what auditors usually request)

### Governance and program hygiene
Evidence examples:
- Security program overview (owner, cadence)
- Policy approval/version history (change control)
- Exception and risk acceptance log (even if small)
- Risk register summary and methodology (if used)

What “good” looks like:
- policies show an approval trail and a revision history
- exceptions are explicit and time-boxed, not hidden

### Identity and access management
Evidence examples:
- MFA enforcement evidence (IdP export)
- Workforce SSO configuration (if used)
- Privileged role inventory (who is admin and why)
- Access reviews (cadence, findings, remediation)
- Joiner/mover/leaver evidence (tickets/logs)

What “good” looks like:
- access review records show reviewer, period, and findings
- privileged changes are logged and attributable

### Logging and monitoring
Evidence examples:
- Central logging coverage (what is logged) and retention
- Alerting/on-call process evidence (routing, escalation)
- RBAC for log access and audit trails
- Example alert triage record (sanitized)

What “good” looks like:
- retention is explicit and backed by config evidence
- alert routing is owned and updated when on-call changes

### Secure SDLC and change management
Evidence examples:
- PR review enforcement (branch protections)
- CI/CD deploy approvals and audit trails
- Separation of duties for production changes (where applicable)
- Vulnerability management cadence and remediation workflow

What “good” looks like:
- controls are enforced by configuration (not policy-only)
- you can provide an example change record and approval

### Incident response and readiness
Evidence examples:
- Incident response plan/playbook (with version history)
- Escalation contacts and roles (kept current)
- Tabletop record / after-action report (sanitized)
- Remediation tracking for gaps found

What “good” looks like:
- tabletop artifacts include gaps, owners, due dates
- post-incident work is tracked to closure

### Vendor and subprocessor management
Evidence examples:
- Vendor inventory (in-scope vendors) with criticality
- Subprocessor list and update cadence
- Vendor due diligence workflow and decision trail
- Vendor incident escalation template (what you ask vendors for)

What “good” looks like:
- decisions are preserved (approve/deny/approve-with-conditions)
- subprocessors include data categories and review cadence

### Training and awareness
Evidence examples:
- Security training assignments and completion logs
- Policy acknowledgments (if used)
- Phishing simulation metrics (if used)

What “good” looks like:
- training exports cover the audit period with timestamps

## Sampling tips (how auditors think)
- Make it easy to sample: label evidence with capture dates and time periods.
- Expect sampling across time: have quarterly records ready, not only “current state”.
- Tie each evidence artifact to a clear control area and owner.
- For sensitive evidence, gate access and log downloads rather than emailing reports.
