# Aurora Command: Security Review Kit

Send reviewers a complete, verifiable security review export in hours, not weeks.

This kit is designed for real security review constraints:
- Reviews are time-boxed and the reviewer is busy.
- “We have a policy” is not enough without scope, evidence, and timestamps.
- Email attachments create version confusion and accidental oversharing.

Use this kit to produce an export that is easy to verify and easy to keep current.

## Who This Is For
- A security owner (or founder) who needs to unblock a deal
- Sales engineering and deal desk coordinating reviewer requests
- Compliance owners standardizing repeatable exports

## What You Will Produce (Deliverables)
- An export outline you can reuse per deal (scope-first, evidence-first)
- A questionnaire triage sheet (owners, deadlines, sensitivity and gating)
- A reviewer index template with artifact IDs, capture dates, and refresh cadence
- Email templates for the initial send and delta updates
- An exception template for owned, dated follow-ups

## Scope (What This Kit Covers)
This kit focuses on the mechanics reviewers actually validate:
- **Scope**: what is covered and excluded (product, environment, timeframe)
- **Evidence**: artifact IDs, indexing, capture dates, and source details
- **Freshness**: evidence that stays current between review cycles
- **Controlled sharing**: tiered access (public, verified, agreement-required)
- **Exceptions**: gaps that are owned, dated, and tracked to closure

This kit does not provide legal advice or contractual commitments.

## What Reviewers Reward (Quality Bar)
If you do these consistently, follow-ups drop dramatically:
- Every claim is scoped (no accidental over-claims)
- Every material claim cites evidence IDs with capture dates
- Every artifact has an owner and a refresh cadence (freshness is explicit)
- Sensitive reports are gated under agreement with a time window and access logs
- Exceptions are explicit (owner, target date, and compensating controls)

## What’s Inside (Files)
- `00-scope-and-contacts-template.md`: scope statement and contacts template you can reuse
- `01-evidence-checklist.md`: what to gather, how to label it, what “good” looks like
- `02-reviewer-export-outline.md`: a reviewer-friendly export structure (with conventions)
- `09-reviewer-export-template.md`: a fill-in export skeleton you can save as a PDF
- `03-common-buyer-questions.md`: common asks and recommended evidence attachments
- `04-questionnaire-triage-sheet.csv`: assign owners, track status, flag agreement needs
- `05-reviewer-index-template.csv`: evidence index template (IDs, capture dates, and gating)
- `06-sharing-templates.md`: email copy and follow-up templates to keep the process tight
- `07-exceptions-template.md`: exception and risk acceptance template reviewers understand
- `08-evidence-capture-playbook.md`: how to capture strong evidence (exports and logs beat screenshots)
- `10-artifact-id-naming-guide.md`: artifact ID conventions and folder structure guidance

## Quick Start (45 Minutes)
1) Define scope (product, environment, timeframe): write it down once and reuse it.
2) Copy `05-reviewer-index-template.csv` and assign an owner per artifact.
3) Copy `04-questionnaire-triage-sheet.csv` and paste in buyer questions as they arrive.
4) Gather evidence using `01-evidence-checklist.md` (prefer exports and logs over screenshots).
5) Share one link once, then respond with delta updates (not attachment re-sends).

## Recommended Workflow (Same Day to 72 Hours)
This is a practical way to run a high-velocity review with minimal rework.

### 0) Before You Write Answers (30 Minutes)
- Confirm the review owner and a backup owner.
- Fill `00-scope-and-contacts-template.md` (one paragraph is enough).
- Decide sharing method: single link or deal room versus attachments (prefer one link).
- Decide gating tiers (public, verified, agreement-required) before collecting artifacts.

### 1) Triage the Request List (30 to 60 Minutes)
- Paste buyer questions into `04-questionnaire-triage-sheet.csv`.
- Tag each question as:
  - Answer only
  - Answer and evidence
  - Agreement required
- Assign owners and deadlines.
- Merge duplicates so you don’t answer the same question repeatedly.

### 2) Build the Reviewer Index First (1 to 2 Hours)
- Start `05-reviewer-index-template.csv` immediately.
- Assign Evidence IDs and owners before writing narrative answers.
- Capture high-signal artifacts first: identity, logging retention, SDLC enforcement, incident response.

### 3) Write Cited Answers (2 to 6 Hours)
Use this format to reduce follow-ups:
1) Scope (what’s covered and what’s excluded)
2) Answer (short, precise)
3) Evidence (Evidence IDs and capture dates)
4) Exceptions (if needed: owner, target date, compensating controls)

### 4) Ship Once, Then Respond With Deltas (Ongoing)
- Send the export link once.
- When follow-ups arrive, reply with:
  - the new Evidence IDs
  - capture dates
  - a one-paragraph “what changed” note
- Do not resend entire attachment sets.

## Evidence Rules (The “No Follow-Up” Standard)
### Prefer Exports and Logs Over Screenshots
Exports are easier to validate, timestamp, and reuse. If you must use screenshots, include:
- A capture date
- The scope (what account or system was captured)
- The path or settings that produced the view

### Keep Scope Explicit in Every Answer
If something varies by deployment (for example, customer-managed authentication), state it clearly.
Most reviewer escalations come from implied scope, not from missing controls.

### Label Artifacts Like a Reviewer
Use stable IDs and avoid renaming files mid-review.
The reviewer should be able to reference “LOG-001” and both sides know what that is.

### Track Freshness on Purpose
Evidence goes stale.
If your evidence inventory has owners and cadence, you can refresh proactively and avoid deadline panic.

## Common Mistakes (And What To Do Instead)
- **Mistake**: “We have a policy” with no approval trail.
  **Instead**: cite the policy, last approved date, and review cadence (or approval excerpt).
- **Mistake**: a folder of PDFs with no index.
  **Instead**: publish an evidence index with IDs, capture dates, and gating tiers.
- **Mistake**: sending sensitive reports by email.
  **Instead**: gate reports under agreement with a time window and access logs.
- **Mistake**: hiding gaps.
  **Instead**: log an exception with owner, target date, and compensating controls.

## FAQ (Common Buyer and Security Review Situations)
### Do We Have To Send SOC 2 or a Pen Test?
Not always.

Start with an export that has scope, citations, and timestamps. If a buyer requires a report, treat it as agreement-required and time-box access.

### What If We Don’t Have Evidence for Something Yet?
Use `07-exceptions-template.md`.

Reviewers prefer an explicit plan (owner and date) over vague claims.

### How Do We Keep This Current Between Deals?
Treat evidence like inventory:
- Assign an owner
- Add a capture date
- Set a refresh cadence
- Ship deltas instead of resending “final” exports

## Notes
- This kit is informational and is not legal advice.
- Tailor the export to your environment, contractual terms, and the reviewer’s request list.

## Want This Generated Automatically From Your Sources?
Request a walkthrough at https://auroracommand.ai/contact
