# Evidence capture playbook (exports > screenshots)

This playbook is a practical guide for capturing evidence reviewers can verify. It focuses on three things:
1) Use the strongest evidence format available.
2) Preserve timestamps and source details.
3) Add enough scope context so a reviewer knows what they are looking at.

## The evidence hierarchy (use top to bottom)
1) Export/log/report from a system of record (best)
2) Configuration dump (machine-readable)
3) Screenshot (acceptable when exports aren’t possible)
4) Narrative-only answer (avoid)

## Minimum metadata for every artifact
Include these fields in your reviewer index:
- Artifact ID (stable, e.g. `IAM-001`)
- Captured date
- Refresh cadence (quarterly/monthly/on change)
- Owner
- Scope notes (what system/environment is covered)
- Sensitivity and gating

## Evidence patterns by topic

### Identity and access (multi-factor authentication (MFA), single sign-on (SSO), privileged roles)
Strong evidence:
- Identity provider (IdP) policy export showing multi-factor authentication (MFA) enforcement
- Privileged role assignment export (who is admin)
- Access review records (period, reviewer, findings)

What to avoid:
- A screenshot of an MFA settings page with no capture date

### Logging and monitoring (retention, alerting, access to logs)
Strong evidence:
- Retention configuration export (retention window)
- Role-based access control (RBAC) export for log access (who can view logs)
- Alert routing summary with on-call ownership

What to avoid:
- Narrative claim “we retain logs” with no configuration evidence

### Secure SDLC and change management
Strong evidence:
- Branch protection rules export/screenshot
- Example pull request (PR) showing required reviews (redacted)
- Deploy approval logs / continuous integration (CI) evidence

What to avoid:
- “We do code review” without enforcement proof

### Incident response
Strong evidence:
- IR playbook with version history/approval trail
- Tabletop AAR with remediation tracking
- Incident timeline template used in practice

What to avoid:
- A playbook with no ownership, cadence, or evidence of exercises

### Vendor and subprocessors
Strong evidence:
- Subprocessor list with update cadence and data categories
- Vendor inventory with tiering and review cadence
- Decision log excerpt (approve/approve-with-conditions/reject)

## Packaging tip: one link, deltas only
If you use a deal room or Trust Center:
- Share one link once.
- Add evidence by artifact ID (deltas) rather than resending attachments.
- Log access to sensitive artifacts (agreement-required).

## Notes
- This guide is informational and is not legal advice.
- Sanitize internal hostnames, account IDs, and sensitive identifiers before sharing.
