# Exceptions and risk acceptance (template)

Use this template when you cannot provide a requested control or evidence today. Reviewers accept gaps when they are explicit, owned, and time-boxed.

## Exception record
- Exception ID:
- Control/topic:
- What is missing (plain language):
- Scope impact:
- Risk (why it matters):
- Compensating controls (what reduces risk today):
- Owner:
- Target date:
- Status: Planned / In progress / Completed
- Proof you will provide when complete (evidence ID):
- Notes:

## Example (sanitized)
- Exception ID: EXC-001
- Control/topic: Tabletop exercise record
- What is missing: No tabletop exercise has been executed in the past 12 months.
- Scope impact: Incident readiness evidence is limited to the IR playbook.
- Risk: Reduced confidence in response execution under pressure.
- Compensating controls: IR plan exists and on-call escalation is defined; incident tickets are tracked.
- Owner: Security lead
- Target date: 2026-02-15
- Proof you will provide when complete: IR-010 (Tabletop AAR and remediation tracker)

## Notes
- Do not hide exceptions in prose. Make them a section with owners and dates.
- Keep exceptions scoped and time-boxed.
- Track closure proof; “completed” without evidence creates follow-ups later.
