# Aurora Command — Sample proof pack (sanitized)

This download demonstrates the structure of a buyer-ready proof pack: scope-first answers, evidence IDs, capture dates, and a binder export a reviewer can sample.

The structure is real.
The sample content is sanitized so it can be shared publicly.

## Who this is for
- Buyer security reviewers who want citations and timestamps
- Compliance/audit stakeholders who need sampling-ready evidence packaging
- Sales engineering or deal desk teams who want a repeatable “proof pack” default

## How to navigate (5 minutes)
1) Open `Buyer-Ready_Packet.pdf` first.
   - Start with scope and the control coverage summary.
   - Follow citations to Evidence IDs.
2) Open `Evidence_Binder_Export.zip` for sampling.
   - Use `index.csv` as the table of contents (captured dates, owners, cadence, and sensitivity).
3) Use the supporting excerpts for deeper verification:
   - `Architecture_Overview.pdf` (ENC-002)
   - `Tabletop_AAR.pdf` (IR-004)
   - `Policy_Approval_Trail_Excerpt.pdf` (governance trail)
   - `Coverage_Verdict_Report.pdf` (what’s covered vs gated)
4) Review vendor packaging in `Vendor_Due_Diligence_Pack.zip` to see a decision trail (questionnaire → evidence index → decision log).

## What’s included
- `Buyer-Ready_Packet.pdf` — the reviewer-friendly packet with citations and a longer appendix
- `Architecture_Overview.pdf` — architecture, data flows, and encryption model excerpts (Evidence ID: ENC-002)
- `Tabletop_AAR.pdf` — tabletop after-action report excerpt plus remediation follow-through (Evidence ID: IR-004)
- `Policy_Approval_Trail_Excerpt.pdf` — version history + approval trail excerpts (sanitized)
- `Coverage_Verdict_Report.pdf` — coverage snapshot and tiered sharing model
- `Evidence_Binder_Export.zip` — evidence artifacts plus `index.csv` and `metadata.json`
- `Vendor_Due_Diligence_Pack.zip` — vendor profile, questionnaire answers, evidence index, risk assessment, and decision log
- `Trust_Center_Access_Logs.csv` — example access logs showing tiered sharing events

## Evidence model (what “proof” means here)
- **Evidence IDs**: every artifact is labeled (IAM-010, LOG-010, SDLC-002) and referenced in answers.
- **Freshness**: every artifact has a capture date and a recommended cadence.
- **Scope notes**: the packet states boundaries (what is covered vs excluded) so reviewers don’t infer too much.
- **Tiered sharing**: sensitive reports are agreement-required and time-boxed; access is logged.

## Reviewer-ready answer format (recommended)
For each question, answer in this structure:
1) **Scope** (what’s covered and what’s excluded)
2) **Answer** (short, precise)
3) **Proof** (Evidence IDs + capture dates)
4) **Exceptions** (only if needed: owner + target date + compensating controls)

## Notes
- Everything here is informational and is not legal advice.
- Replace sample artifacts with your real exports and evidence.
- Do not claim a control is in place unless you can cite proof and scope.
